<?php  
session_start();
require_once("../config/conexion.php");

// Verificar sesión activa
if (!isset($_SESSION['id_rol'])) {
    header("Location: ../login.php");
    exit();
}

// Determinar URL de inicio según rol
$id_rol = $_SESSION['id_rol'];
$inicio_url = match ($id_rol) {
    1 => "/index.php",
    2 => "../views/dashboard_funcionario.php",
    default => "/login.php"
};

// Obtener libros con stock disponible
$sql_libros = "
SELECT 
    libros.id,
    libros.titulo,
    libros.autor,
    libros.fecha_publicacion,
    libros.stock,
    (libros.stock - IFNULL(COUNT(prestamos.id), 0)) AS stock_disponible
FROM libros
LEFT JOIN prestamos ON prestamos.libro_id = libros.id AND prestamos.fecha_devolucion_real IS NULL
GROUP BY libros.id
HAVING stock_disponible > 0
";
$result_libros = $conn->query($sql_libros);

// Obtener usuarios
$sql_usuarios = "SELECT rut_usuario AS rut, nombre_usuario AS nombre, 'Usuario' AS tipo, NULL AS curso FROM usuarios";
$result_usuarios = $conn->query($sql_usuarios);

// Obtener alumnos con curso
$sql_alumnos = "
    SELECT alumnos.rut, alumnos.nombre_alumno AS nombre, 'Alumno' AS tipo, 
           CONCAT(cursos.nivel, cursos.seccion) AS curso
    FROM alumnos
    LEFT JOIN cursos ON alumnos.curso_id = cursos.id
    WHERE alumnos.activo = 1
";
$result_alumnos = $conn->query($sql_alumnos);

// Combinar resultados
$personas = [];

if ($result_usuarios) {
    while ($usuario = $result_usuarios->fetch_assoc()) {
        $personas[] = $usuario;
    }
}

if ($result_alumnos) {
    while ($alumno = $result_alumnos->fetch_assoc()) {
        $personas[] = $alumno;
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Realizar Préstamo</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="/css/prestamos.css">
</head>
<body>

  <div class="container">
    <img src="/img/INSIGNIA SF.png" alt="Logo" class="logo">
    <h2>Realizar Préstamo de Libro</h2>

    <?php if (isset($_SESSION['mensaje'])): ?>
      <div class="mensaje">
        <?php 
          echo htmlspecialchars($_SESSION['mensaje']);
          unset($_SESSION['mensaje']);
        ?>
      </div>
    <?php endif; ?>

    <form action="../controllers/procesar_prestamo.php" method="POST" enctype="multipart/form-data">
      
      <label for="usuario_id">Rut del Usuario:</label>
      <select id="usuario_id" name="usuario_id" required>
        <option value="">-- Selecciona un usuario o alumno --</option>
        <?php foreach ($personas as $persona): ?>
          <option value="<?php echo htmlspecialchars($persona['rut']); ?>">
            <?php 
              echo htmlspecialchars($persona['nombre']) . " (" . htmlspecialchars($persona['rut']) . ") - " . $persona['tipo'];
              if (!empty($persona['curso'])) {
                  echo " - Curso: " . htmlspecialchars($persona['curso']);
              }
            ?>
          </option>
        <?php endforeach; ?>
      </select>

      <label for="libro_id">Libro a Prestar:</label>
<select id="libro_id" name="libro_id" required>
    <option value="">-- Selecciona un libro disponible --</option>
    <?php if ($result_libros && $result_libros->num_rows > 0): ?>
        <?php while($libro = $result_libros->fetch_assoc()): ?>
            <option value="<?php echo htmlspecialchars($libro['id']); ?>">
                <?php 
                echo htmlspecialchars($libro['titulo']) . " - " .
                     htmlspecialchars($libro['autor']) . " (" .
                     date('Y', strtotime($libro['fecha_publicacion'])) . ") - Stock: " .
                     $libro['stock_disponible'];
                ?>
            </option>
        <?php endwhile; ?>
    <?php else: ?>
        <option value="">No hay libros disponibles</option>
    <?php endif; ?>
</select>


      <label for="fecha_prestamo">Fecha de Préstamo:</label>
      <input type="date" id="fecha_prestamo" name="fecha_prestamo" required 
             value="<?php echo date('Y-m-d'); ?>">

      <label for="fecha_devolucion">Fecha de Devolución Estimada:</label>
      <input type="date" id="fecha_devolucion" name="fecha_devolucion" required 
             value="<?php echo date('Y-m-d', strtotime('+7 days')); ?>">

      <button type="submit">Registrar Préstamo</button>
    </form>

    <div class="volver-container">
      <a href="<?php echo $inicio_url; ?>" class="btn-volver">🏠 Volver al Inicio</a>
    </div>
  </div>

</body>
</html>

<?php $conn->close(); ?>