document.addEventListener('DOMContentLoaded', function () {
    const urlParams = new URLSearchParams(window.location.search);
    if (urlParams.get('registro') === 'ok') {
        const notificacion = document.createElement('div');
        notificacion.textContent = "✅ Registro exitoso.";
        notificacion.style.position = 'fixed';
        notificacion.style.top = '20px';
        notificacion.style.right = '20px';
        notificacion.style.backgroundColor = '#28a745';
        notificacion.style.color = '#fff';
        notificacion.style.padding = '12px 20px';
        notificacion.style.borderRadius = '8px';
        notificacion.style.boxShadow = '0 4px 10px rgba(0,0,0,0.2)';
        notificacion.style.zIndex = '9999';
        document.body.appendChild(notificacion);

        setTimeout(() => {
            notificacion.remove();
            window.history.replaceState(null, null, window.location.pathname);
        }, 1500);
    }
});