<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once "../config/conexion.php";
require_once "../vendor/autoload.php";

use PhpOffice\PhpSpreadsheet\IOFactory;

$mensaje = "";

// Registrar nuevo docente manualmente
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['action'])) {
    if ($_POST['action'] == 'register') {
        $nombre = trim($_POST['nombre_docente']);
        $rut = trim($_POST['rut_docente']);
        $clave = $_POST['contraseña'];

        if (!empty($nombre) && !empty($rut) && !empty($clave)) {
            $sql_check = "SELECT id FROM docentes WHERE rut = ?";
            $stmt_check = $conn->prepare($sql_check);
            $stmt_check->bind_param("s", $rut);
            $stmt_check->execute();
            $stmt_check->store_result();

            if ($stmt_check->num_rows > 0) {
                $mensaje = "⚠️ El RUT ya está registrado como docente.";
            } else {
                $clave_hash = password_hash($clave, PASSWORD_DEFAULT);
                $id_rol = 4;
                $curso_id = null; // Aquí podrías asignar si quieres

                $sql = "INSERT INTO docentes (nombre_docente, rut, contraseña, activo, id_rol, curso_id) 
                        VALUES (?, ?, ?, 1, ?, ?)";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("sssii", $nombre, $rut, $clave_hash, $id_rol, $curso_id);

                if ($stmt->execute()) {
                    header("Location: registro_docentes.php?registro=ok");
                    exit();
                } else {
                    $mensaje = "❌ Error al registrar docente.";
                }
            }

            $stmt_check->close();
        } else {
            $mensaje = "⚠️ Por favor, completa todos los campos correctamente.";
        }
    }

// Importar desde Excel
    elseif ($_POST['action'] == 'import_excel') {
        if (isset($_FILES['excel_file']) && $_FILES['excel_file']['error'] == 0) {
            $archivoExcel = $_FILES['excel_file']['tmp_name'];
            $spreadsheet = IOFactory::load($archivoExcel);
            $sheet = $spreadsheet->getActiveSheet();
            $rows = $sheet->toArray();

            $rowCount = 0;

            foreach ($rows as $index => $row) {
                if ($index == 0) continue; // Saltar encabezado

                $rut = trim($row[0]); // RUT
                $nombre = trim($row[1]);
                $apellido_paterno = trim($row[2]);
                $apellido_materno = trim($row[3]);
                $clave = trim($row[4]);
                $curso_texto = isset($row[5]) ? trim($row[5]) : '';
                $activo = isset($row[6]) ? intval($row[6]) : 1;

                $nombre_completo = $nombre . ' ' . $apellido_paterno . ' ' . $apellido_materno;

                if ($rut && $nombre_completo && $clave !== '') {
                    $clave_hash = password_hash($clave, PASSWORD_DEFAULT);
                    $id_rol = 4; // Rol docente

                    // Obtener curso_id desde la tabla cursos
                    $curso_id = null;
                    if ($curso_texto) {
                        $partes = explode(' ', $curso_texto);
                        $nivel = isset($partes[0]) ? $partes[0] : '';
                        $seccion = isset($partes[1]) ? $partes[1] : '';

                        $sql_curso = "SELECT id FROM cursos WHERE nivel = ? AND seccion = ?";
                        $stmt_curso = $conn->prepare($sql_curso);
                        if ($stmt_curso) {
                            $stmt_curso->bind_param("ss", $nivel, $seccion);
                            $stmt_curso->execute();
                            $result_curso = $stmt_curso->get_result();
                            if ($result_curso && $result_curso->num_rows > 0) {
                                $curso_data = $result_curso->fetch_assoc();
                                $curso_id = $curso_data['id'];
                            }
                            $stmt_curso->close();
                        }
                    }

                    // Verificar si ya existe el docente
                    $sql_check = "SELECT id FROM docentes WHERE rut = ?";
                    $stmt_check = $conn->prepare($sql_check);
                    $stmt_check->bind_param("s", $rut);
                    $stmt_check->execute();
                    $stmt_check->store_result();

                    if ($stmt_check->num_rows > 0) {
                        // Ya existe: hacer UPDATE
                        $sql_update = "UPDATE docentes SET nombre_docente = ?, contraseña = ?, activo = ?, id_rol = ?, curso_id = ? WHERE rut = ?";
                        $stmt_update = $conn->prepare($sql_update);
                        $stmt_update->bind_param("ssiiss", $nombre_completo, $clave_hash, $activo, $id_rol, $curso_id, $rut);
                        if ($stmt_update->execute()) {
                            $rowCount++;
                        }
                        $stmt_update->close();
                    } else {
                        // No existe: hacer INSERT
                        $sql_insert = "INSERT INTO docentes (nombre_docente, rut, contraseña, activo, id_rol, curso_id) 
                                       VALUES (?, ?, ?, ?, ?, ?)";
                        $stmt_insert = $conn->prepare($sql_insert);
                        $stmt_insert->bind_param("sssiii", $nombre_completo, $rut, $clave_hash, $activo, $id_rol, $curso_id);
                        if ($stmt_insert->execute()) {
                            $rowCount++;
                        }
                        $stmt_insert->close();
                    }

                    $stmt_check->close();
                }
            }

            $mensaje = "✅ Se importaron o actualizaron $rowCount docentes correctamente.";
        } else {
            $mensaje = "❌ Error al cargar el archivo.";
        }
    }
}

// Obtener docentes registrados
$sql_docentes = "SELECT id, nombre_docente, rut FROM docentes ORDER BY nombre_docente ASC";
$resultado = $conn->query($sql_docentes);
$docentes = $resultado->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Registrar Docente</title>
    <link rel="stylesheet" href="/css/registro_usuarios.css">
</head>
<body>

<div class="registro-container">
    <img src="/img/INSIGNIA SF.png" alt="Logo" class="logo">
    <h2>Registrar Nuevo Docente</h2>

    <?php if ($mensaje): ?>
        <div class="mensaje"><?php echo $mensaje; ?></div>
    <?php endif; ?>

    <!-- Registro individual -->
    <form method="POST">
        <input type="hidden" name="action" value="register">

        <label for="rut_docente">RUT del Docente:</label>
        <input type="text" name="rut_docente" id="rut_docente" required>

        <label for="nombre_docente">Nombre Completo:</label>
        <input type="text" name="nombre_docente" id="nombre_docente" required>

        <label for="contraseña">Contraseña:</label>
        <input type="password" name="contraseña" id="contraseña" required>

        <button type="submit">Registrar Docente</button>
    </form>

    <hr>

    <!-- Formulario de importación -->
    <h3>Importar Docentes desde Excel (.xlsx)</h3>
    <form method="POST" enctype="multipart/form-data">
        <input type="hidden" name="action" value="import_excel">

        <label for="excel_file">Selecciona el archivo Excel:</label>
        <input type="file" name="excel_file" id="excel_file" accept=".xlsx" required>

        <button type="submit">📥 Importar Archivo</button>

        <p style="margin-top: 10px;">
            📄 ¿No tienes el formato? <a href="../files/Plantilla de Docentes.xlsx" download style="color: #2563eb; font-weight: 500;">Descargar Plantilla Excel</a>
        </p>
    </form>

    <div class="botones-container">
        <a href="/index.php" class="volver-btn">🏠 Volver al Inicio</a>
    </div>
</div>

<script src="/js/notificacion_registro.js"></script>

</body>
</html>
