<?php
session_start(); // Asegúrate de iniciar la sesión
require_once '../config/conexion.php';

$registros_por_pagina = 10;
$pagina = isset($_POST['pagina']) ? (int)$_POST['pagina'] : 1;
$inicio = ($pagina - 1) * $registros_por_pagina;

// Filtros
$rol_filtro = isset($_POST['rol']) ? $_POST['rol'] : '';
$curso_filtro = isset($_POST['curso']) ? $_POST['curso'] : '';
$busqueda = isset($_POST['busqueda']) ? trim($_POST['busqueda']) : '';

// Escapar para seguridad
$rol_filtro_esc = $conn->real_escape_string($rol_filtro);
$curso_filtro_esc = $conn->real_escape_string($curso_filtro);
$busqueda_esc = $conn->real_escape_string($busqueda);

// Construir WHERE para cada tabla
$where_usuarios = [];
$where_alumnos = [];
$where_docentes = [];

// Por rol
if (!empty($rol_filtro_esc)) {
    $where_usuarios[] = "id_rol = '$rol_filtro_esc'";
    $where_alumnos[] = "id_rol = '$rol_filtro_esc'";
    $where_docentes[] = "id_rol = '$rol_filtro_esc'";
}

// Por curso
if (!empty($curso_filtro_esc)) {
    $where_usuarios[] = "curso_id = '$curso_filtro_esc'";
    $where_alumnos[] = "curso_id = '$curso_filtro_esc'";
    $where_docentes[] = "curso_id = '$curso_filtro_esc'";
}

// Por búsqueda
if (!empty($busqueda_esc)) {
    $where_usuarios[] = "(nombre_usuario LIKE '%$busqueda_esc%' OR rut_usuario LIKE '%$busqueda_esc%' OR correo LIKE '%$busqueda_esc%')";
    $where_alumnos[] = "(nombre_alumno LIKE '%$busqueda_esc%' OR rut LIKE '%$busqueda_esc%' OR correo LIKE '%$busqueda_esc%')";
    $where_docentes[] = "(nombre_docente LIKE '%$busqueda_esc%' OR rut LIKE '%$busqueda_esc%')";
}

// Solo activos
$where_alumnos[] = "activo = 1";
$where_docentes[] = "activo = 1";

// Cláusulas WHERE finales
$where_sql_usuarios = !empty($where_usuarios) ? "WHERE " . implode(" AND ", $where_usuarios) : "";
$where_sql_alumnos = !empty($where_alumnos) ? "WHERE " . implode(" AND ", $where_alumnos) : "";
$where_sql_docentes = !empty($where_docentes) ? "WHERE " . implode(" AND ", $where_docentes) : "";

// Consulta con UNION
$sql_total = "
    SELECT id, nombre_usuario AS nombre, rut_usuario AS rut, correo, id_rol, curso_id AS curso, 'usuarios' AS origen
    FROM usuarios
    $where_sql_usuarios

    UNION ALL

    SELECT id, nombre_alumno AS nombre, rut, correo, id_rol, curso_id AS curso, 'alumnos' AS origen
    FROM alumnos
    $where_sql_alumnos

    UNION ALL

    SELECT id, nombre_docente AS nombre, rut, NULL AS correo, id_rol, curso_id AS curso, 'docentes' AS origen
    FROM docentes
    $where_sql_docentes

    LIMIT $inicio, $registros_por_pagina
";

$resultado = $conn->query($sql_total);

// Conteo total
$sql_conteo = "
    SELECT COUNT(*) AS total FROM (
        SELECT id FROM usuarios $where_sql_usuarios
        UNION ALL
        SELECT id FROM alumnos $where_sql_alumnos
        UNION ALL
        SELECT id FROM docentes $where_sql_docentes
    ) AS total_usuarios
";

$total_resultado = $conn->query($sql_conteo);
$total_fila = $total_resultado->fetch_assoc();
$total_usuarios = $total_fila['total'];
$total_paginas = ceil($total_usuarios / $registros_por_pagina);
$pagina_actual = $pagina;

// URL para volver al inicio
$inicio_url = '#';
if (isset($_SESSION['id_rol'])) {
    switch ($_SESSION['id_rol']) {
        case 1:
            $inicio_url = '/index.php';
            break;
        case 2:
            $inicio_url = '/views/dashboard_funcionario.php';
            break;
        default:
            $inicio_url = 'index.php';
            break;
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Lista de Usuarios</title>
    <link rel="stylesheet" href="/css/lista_usuarios.css">
    
</head>
<body>
    <img src="/img/INSIGNIA SF.png" alt="Logo" class="logo">
    <h2>Lista de Usuarios Registrados</h2>

    <form method="POST" class="filtros-form">
        <input type="text" name="busqueda" placeholder="Buscar por nombre, RUT o correo" value="<?= htmlspecialchars($busqueda) ?>">
        <select name="rol">
            <option value="">Todos los roles</option>
            <option value="1" <?= $rol_filtro == '1' ? 'selected' : '' ?>>Administrador</option>
            <option value="2" <?= $rol_filtro == '2' ? 'selected' : '' ?>>Funcionario</option>
            <option value="3" <?= $rol_filtro == '3' ? 'selected' : '' ?>>Alumno</option>
            <option value="4" <?= $rol_filtro == '4' ? 'selected' : '' ?>>Docente</option>
        </select>
        <select name="curso">
            <option value="">Todos los cursos</option>
            <?php
            $cursos_result = $conn->query("SELECT id, nivel, seccion FROM cursos ORDER BY nivel, seccion");
            while ($curso = $cursos_result->fetch_assoc()) {
                $valor = $curso['id'];
                $texto = $curso['nivel'] . '°' . $curso['seccion'];
                $selected = $curso_filtro == $valor ? 'selected' : '';
                echo "<option value='$valor' $selected>$texto</option>";
            }
            ?>
        </select>
        <button type="submit">Filtrar</button>
    </form>

    <?php if ($resultado && $resultado->num_rows > 0): ?>
        <form method='POST' action='eliminar_usuarios_multiples.php'>
            <table class='tabla-usuarios'>
                <thead>
                    <tr>
                        <th>Seleccionar</th>
                        <th>Nombre</th>
                        <th>RUT</th>
                        <th>Correo</th>
                        <th>Rol</th>
                        <th>Curso</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($usuario = $resultado->fetch_assoc()): ?>
                        <tr>
                            <td><input type='checkbox' name='usuarios_ids[]' value='<?= $usuario['id'] ?>|<?= $usuario['origen'] ?>'></td>
                            <td><?= htmlspecialchars($usuario['nombre']) ?></td>
                            <td><?= htmlspecialchars($usuario['rut']) ?></td>
                            <td><?= htmlspecialchars($usuario['correo'] ?? '-') ?></td>
                            <td>
                                <?php
                                switch ($usuario['id_rol']) {
                                    case 1: echo 'Administrador'; break;
                                    case 2: echo 'Funcionario'; break;
                                    case 3: echo 'Alumno'; break;
                                    case 4: echo 'Docente'; break;
                                    default: echo 'Desconocido'; break;
                                }
                                ?>
                            </td>
                            <td><?= htmlspecialchars($usuario['curso'] ?? '-') ?></td>
                            <td>
                                <a href='editar_usuarios.php?id=<?= $usuario['id'] ?>&rol=<?= $usuario['id_rol'] ?>&origen=<?= $usuario['origen'] ?>' class='btn-editar'>Editar</a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
            <button type='submit' class='btn-eliminar-seleccionados' onclick="return confirm('¿Estás seguro de eliminar los usuarios seleccionados?')">Eliminar seleccionados</button>
        </form>
    <?php else: ?>
        <p>No se encontraron usuarios.</p>
    <?php endif; ?>

    <?php if ($total_paginas > 1): ?>
        <div class="paginacion">
            <?php for ($i = 1; $i <= $total_paginas; $i++): ?>
                <form method="POST" style="display:inline;">
                    <input type="hidden" name="pagina" value="<?= $i ?>">
                    <input type="hidden" name="rol" value="<?= htmlspecialchars($rol_filtro) ?>">
                    <input type="hidden" name="curso" value="<?= htmlspecialchars($curso_filtro) ?>">
                    <input type="hidden" name="busqueda" value="<?= htmlspecialchars($busqueda) ?>">
                    <button type="submit" <?= ($i == $pagina_actual) ? 'class="pagina-actual"' : '' ?>><?= $i ?></button>
                </form>
            <?php endfor; ?>
        </div>
    <?php endif; ?>

    <!-- Botón volver al inicio -->
    <div style="text-align: center;">
        <a href="<?= $inicio_url ?>" class="btn-volver-inicio">← Volver al Inicio</a>
    </div>
</body>
</html>
