<?php
require_once "../config/conexion.php";
session_start(); // Asegura que se pueda acceder a $_SESSION

// Determinar URL de inicio según rol
$id_rol = $_SESSION['id_rol'] ?? null;
$inicio_url = match ($id_rol) {
    1 => "/index.php", // Admin
    2 => "../views/dashboard_funcionario.php", // Funcionario
    default => "/login.php"
};

// Filtros y búsqueda
$busqueda = isset($_GET['busqueda']) ? $conn->real_escape_string($_GET['busqueda']) : '';

// Base de la consulta
$sql_base = "
    FROM libros
    LEFT JOIN (
        SELECT libro_id, COUNT(*) AS prestamos_activos
        FROM prestamos
        WHERE fecha_devolucion_real IS NULL
        GROUP BY libro_id
    ) AS prestamos_activos ON libros.id = prestamos_activos.libro_id
    WHERE 1
";

if (!empty($busqueda)) {
    $sql_base .= " AND titulo LIKE '%$busqueda%'";
}

// Paginación
$registros_por_pagina = 10;
$pagina_actual = isset($_GET['pagina']) ? max(1, (int)$_GET['pagina']) : 1;
$offset = ($pagina_actual - 1) * $registros_por_pagina;

// Total para paginación
$total_resultado = $conn->query("SELECT COUNT(*) as total $sql_base");
$total_filas = $total_resultado->fetch_assoc()['total'];
$total_paginas = ceil($total_filas / $registros_por_pagina);

// Consulta final con cálculo de stock disponible
$sql_libros = "
    SELECT libros.*, 
           libros.stock - IFNULL(prestamos_activos.prestamos_activos, 0) AS stock_disponible
    $sql_base
    LIMIT $offset, $registros_por_pagina
";

$resultado = $conn->query($sql_libros);
if (!$resultado) {
    die("Error en la consulta: " . $conn->error);
}
$libros = $resultado->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Libros Registrados</title>
    <link rel="stylesheet" href="/css/lista_libros.css">
</head>
<body>
    <div class="libros-registrados">
        <img src="/img/INSIGNIA SF.png" alt="Logo" class="logo">
        <h2>Libros Registrados</h2>

        <div class="botones-container">
            <a href="<?php echo $inicio_url; ?>" class="volver-btn">🏠 Volver al Inicio</a>
        </div>

        <form class="filtro-container" method="GET">
            <input type="text" name="busqueda" placeholder="Buscar por título..." value="<?php echo htmlspecialchars($busqueda); ?>">
            <button type="submit">🔍Buscar</button>
        </form>

        <form method="POST" action="../controllers/eliminar_libros_multiple.php" onsubmit="return confirm('¿Estás seguro de eliminar los libros seleccionados?');">
            <div class="cuadro-contenedor">
                <table>
                    <thead>
                        <tr>
                            <th><input type="checkbox" onclick="toggleCheckboxes(this)"></th>
                            <th>Título</th>
                            <th>Autor</th>
                            <th>Fecha de Publicación</th>
                            <th>Stock Disponible</th>
                            <th>Acción</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($libros as $libro): ?>
                            <tr>
                                <td><input type="checkbox" name="libros_seleccionados[]" value="<?php echo $libro['id']; ?>"></td>
                                <td><?php echo htmlspecialchars($libro['titulo']); ?></td>
                                <td><?php echo htmlspecialchars($libro['autor']); ?></td>
                                <td><?php echo $libro['fecha_publicacion']; ?></td>
                                <td><?php echo max(0, $libro['stock_disponible']); ?></td>
                                <td><a href="../controllers/editar_libros.php?id=<?php echo $libro['id']; ?>" class="btn-editar">Editar</a></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <div class="boton-eliminar-container">
                <button type="submit" class="btn-eliminar-multiple">🗑️ Eliminar Seleccionados</button>
            </div>
        </form>

        <div class="paginacion">
            <?php if ($pagina_actual > 1): ?>
                <a href="?pagina=<?php echo $pagina_actual - 1; ?>&busqueda=<?php echo urlencode($busqueda); ?>">&laquo; Anterior</a>
            <?php endif; ?>

            <?php for ($i = 1; $i <= $total_paginas; $i++): ?>
                <a href="?pagina=<?php echo $i; ?>&busqueda=<?php echo urlencode($busqueda); ?>"
                   class="<?php echo $i == $pagina_actual ? 'pagina-actual' : ''; ?>">
                   <?php echo $i; ?>
                </a>
            <?php endfor; ?>

            <?php if ($pagina_actual < $total_paginas): ?>
                <a href="?pagina=<?php echo $pagina_actual + 1; ?>&busqueda=<?php echo urlencode($busqueda); ?>">Siguiente &raquo;</a>
            <?php endif; ?>
        </div>
    </div>

    <script>
    function toggleCheckboxes(source) {
        const checkboxes = document.querySelectorAll('input[name="libros_seleccionados[]"]');
        checkboxes.forEach(checkbox => checkbox.checked = source.checked);
    }
    </script>
</body>
</html>