<?php
require_once "../config/conexion.php";

$id = $_GET['id'] ?? null;

// Verifica si el ID es válido
if (!$id) {
    exit("ID no especificado.");
}

// Verificar si el libro existe
$sql_check = "SELECT * FROM libros WHERE id = ?";
$stmt_check = $conn->prepare($sql_check);
$stmt_check->bind_param("i", $id);
$stmt_check->execute();
$result = $stmt_check->get_result();

if ($result->num_rows == 0) {
    exit("El libro con el ID especificado no existe.");
}
$stmt_check->close();

// Eliminar el libro
$sql = "DELETE FROM libros WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $id);

if ($stmt->execute()) {
    header("Location: ../controllers/registro_libros.php");
    exit();
} else {
    echo "Error al eliminar el libro: " . $stmt->error;
}
?>
