<?php 
require_once "../config/conexion.php";
ini_set('display_errors', 1);
error_reporting(E_ALL);

$mensaje = "";
$usuario = [];
$es_alumno = false;

// Obtener datos del usuario si viene por GET
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['id']) && is_numeric($_GET['id'])) {
    $id_usuario = intval($_GET['id']);

    // Buscar en usuarios
    $sql_usuario = "SELECT * FROM usuarios WHERE id = ?";
    $stmt_usuario = $conn->prepare($sql_usuario);
    $stmt_usuario->bind_param("i", $id_usuario);
    $stmt_usuario->execute();
    $usuario_resultado = $stmt_usuario->get_result();
    $usuario = $usuario_resultado->fetch_assoc();

    if (!$usuario) {
        // Buscar en alumnos
        $sql_alumno = "SELECT * FROM alumnos WHERE id = ?";
        $stmt_alumno = $conn->prepare($sql_alumno);
        $stmt_alumno->bind_param("i", $id_usuario);
        $stmt_alumno->execute();
        $alumno_resultado = $stmt_alumno->get_result();
        $usuario = $alumno_resultado->fetch_assoc();

        if ($usuario) {
            $es_alumno = true;
        } else {
            $mensaje = "❌ Usuario no encontrado.";
        }
    }
} else if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $mensaje = "⚠️ ID de usuario no válido.";
}

// Obtener cursos disponibles
$sql_cursos = "SELECT * FROM cursos";
$resultado_cursos = $conn->query($sql_cursos);
$cursos = $resultado_cursos->fetch_all(MYSQLI_ASSOC);

// Procesar formulario (editar)
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['action']) && $_POST['action'] === 'edit') {
    if (isset($_POST['id']) && is_numeric($_POST['id'])) {
        $id_usuario = intval($_POST['id']);
        $nombre_usuario = trim($_POST['nombre_usuario']);
        $rut = trim($_POST['rut_usuario']);
        $correo = trim($_POST['correo']);
        $clave = $_POST['contraseña'];
        $rol = intval($_POST['id_rol']);
        $curso = isset($_POST['curso']) && $_POST['curso'] !== "" ? intval($_POST['curso']) : null;
        $es_alumno = isset($_POST['es_alumno']) && $_POST['es_alumno'] === '1';

        if (!empty($nombre_usuario) && !empty($clave) && !empty($rut) && !empty($correo)) {
            $clave_hash = password_hash($clave, PASSWORD_DEFAULT);

            if ($es_alumno) {
                $sql = "UPDATE alumnos SET nombre_alumno = ?, rut = ?, correo = ?, contraseña = ?, curso_id = ?, id_rol = ? WHERE id = ?";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("ssssiii", $nombre_usuario, $rut, $correo, $clave_hash, $curso, $rol, $id_usuario);
            } else {
                $sql = "UPDATE usuarios SET nombre_usuario = ?, rut_usuario = ?, correo = ?, contraseña = ?, id_rol = ?, curso_id = ? WHERE id = ?";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("ssssiii", $nombre_usuario, $rut, $correo, $clave_hash, $rol, $curso, $id_usuario);
            }

            if ($stmt->execute()) {
                header("Location: ../controllers/lista_usuarios.php?edit=ok");
                exit();
            } else {
                $mensaje = "❌ Error al actualizar: " . $stmt->error;
            }
        } else {
            $mensaje = "⚠️ Por favor, completa todos los campos correctamente.";
        }
    } else {
        $mensaje = "❌ Error: ID de usuario no válido.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Editar Usuario</title>
    <link rel="stylesheet" href="/css/editar_usuarios.css">
</head>
<body>

<div class="registro-container">
    <img src="/img/INSIGNIA SF.png" alt="Logo" class="logo">
    <h2>Editar Usuario</h2>

    <?php if ($mensaje): ?>
        <div class="mensaje"><?php echo $mensaje; ?></div>
    <?php endif; ?>

    <?php if (!empty($usuario)): ?>
    <form method="POST">
        <input type="hidden" name="action" value="edit">
        <input type="hidden" name="id" value="<?php echo htmlspecialchars($usuario['id']); ?>">
        <input type="hidden" name="es_alumno" value="<?php echo $es_alumno ? '1' : '0'; ?>">

        <label for="nombre_usuario">Nombre:</label>
        <input type="text" name="nombre_usuario" id="nombre_usuario"
               value="<?php echo htmlspecialchars($es_alumno ? $usuario['nombre_alumno'] : $usuario['nombre_usuario']); ?>" required>

        <label for="rut_usuario">RUT:</label>
        <input type="text" name="rut_usuario" id="rut_usuario"
               value="<?php echo htmlspecialchars($es_alumno ? $usuario['rut'] : $usuario['rut_usuario']); ?>" required>

        <label for="correo">Correo Electrónico:</label>
        <input type="email" name="correo" id="correo"
               value="<?php echo htmlspecialchars($usuario['correo']); ?>" required>

        <label for="contraseña">Contraseña:</label>
        <div style="position: relative;">
            <input type="password" name="contraseña" id="contraseña" value="" required style="padding-right: 40px;">
            <button type="button" onclick="togglePassword()" style="position: absolute; right: 10px; top: 50%; transform: translateY(-50%); background: none; border: none; cursor: pointer;">
                <span id="icono-ojo">👁️</span>
            </button>
        </div>

        <label for="id_rol">Rol:</label>
        <select name="id_rol" id="id_rol" required>
            <option value="">Selecciona un rol</option>
            <option value="1" <?php echo ($usuario['id_rol'] == 1) ? 'selected' : ''; ?>>Admin</option>
            <option value="2" <?php echo ($usuario['id_rol'] == 2) ? 'selected' : ''; ?>>Funcionario</option>
            <option value="3" <?php echo ($usuario['id_rol'] == 3) ? 'selected' : ''; ?>>Alumno</option>
        </select>

        <?php if ($es_alumno): ?>
            <label for="curso">Curso:</label>
            <select name="curso" id="curso" required>
                <option value="">Seleccione un curso</option>
                <?php foreach ($cursos as $curso): ?>
                    <option value="<?php echo $curso['id']; ?>" <?php echo ($curso['id'] == $usuario['curso_id']) ? 'selected' : ''; ?>>
                        <?php echo $curso['nivel'] . "°" . $curso['seccion']; ?>
                    </option>
                <?php endforeach; ?>
            </select>
        <?php endif; ?>

        <button type="submit">Actualizar Usuario</button>
    </form>
    <?php else: ?>
        <p style="color: red;">⚠️ No se pudo cargar la información del usuario.</p>
    <?php endif; ?>

    <div class="botones-container">
        <a href="/index.php" class="volver-btn">🏠 Volver al Inicio</a>
    </div>
</div>

<script src="../js/editar_usuarios.js"></script>
</body>
</html>