<?php
session_start(); // Iniciar sesión para obtener id_rol
require_once "../config/conexion.php";

$mensaje = "";
$id = isset($_GET['id']) ? filter_var($_GET['id'], FILTER_VALIDATE_INT) : null;

if (!$id) {
    exit("⚠️ ID de libro no válido o no proporcionado.");
}

// Redirigir según rol
if (isset($_SESSION['id_rol'])) {
    switch ($_SESSION['id_rol']) {
        case 1: // Admin
            $inicio_url = '/index.php';
            break;
        case 2: // Funcionario
            $inicio_url = '/views/dashboard_funcionario.php';
            break;
        default:
            $inicio_url = '/index.php';
            break;
    }
} else {
    $inicio_url = '/index.php';
}

// Obtener datos actuales del libro
$sql = "SELECT * FROM libros WHERE id = ?";
$stmt = $conn->prepare($sql);
if (!$stmt) {
    exit("❌ Error al preparar la consulta: " . $conn->error);
}
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$libro = $result->fetch_assoc();

if (!$libro) {
    exit("❌ Libro no encontrado.");
}

// Procesar el formulario
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $titulo = trim($_POST['titulo']);
    $autor = trim($_POST['autor']);
    $fecha_publicacion = $_POST['fecha_publicacion'];

    if (!empty($titulo) && !empty($autor) && !empty($fecha_publicacion)) {
        $sql_update = "UPDATE libros SET titulo = ?, autor = ?, fecha_publicacion = ? WHERE id = ?";
        $stmt = $conn->prepare($sql_update);

        if ($stmt) {
            $stmt->bind_param("sssi", $titulo, $autor, $fecha_publicacion, $id);

            if ($stmt->execute()) {
                header("Location: $inicio_url?msg=edit_success");
                exit();
            } else {
                $mensaje = "❌ Error al actualizar el libro: " . $stmt->error;
            }
        } else {
            $mensaje = "❌ Error al preparar la actualización: " . $conn->error;
        }
    } else {
        $mensaje = "⚠️ Todos los campos son obligatorios.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Editar Libro</title>
    <link rel="stylesheet" href="/css/editar_libros.css" />
</head>
<body>
    <div class="registro-container">
        <img src="/img/INSIGNIA SF.png" alt="Logo" class="logo" />
        <h2>Editar Libro</h2>

        <?php if (!empty($mensaje)): ?>
            <div class="mensaje"><?php echo htmlspecialchars($mensaje); ?></div>
        <?php endif; ?>

        <form method="POST">
            <label for="titulo">Título:</label>
            <input type="text" id="titulo" name="titulo" value="<?php echo htmlspecialchars($libro['titulo']); ?>" required />

            <label for="autor">Autor:</label>
            <input type="text" id="autor" name="autor" value="<?php echo htmlspecialchars($libro['autor']); ?>" required />

            <label for="fecha_publicacion">Fecha de Publicación:</label>
            <input type="date" id="fecha_publicacion" name="fecha_publicacion" value="<?php echo htmlspecialchars($libro['fecha_publicacion']); ?>" required />

            <button type="submit">Guardar Cambios</button>
            <div class="botones-container">
                <a href="<?php echo $inicio_url; ?>" class="volver-btn">🏠 Volver al Inicio</a>
            </div>
        </form>
    </div>
</body>
</html>